//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.Threading;
using System.Runtime.InteropServices;
using System.Security;
using System.Security.Permissions;
using System.IO;
using System.Text;

namespace Exceptions
{
	class Recurse
	{
		public static void StackOverflow()
		{
			Recurse.StackOverflow();
		}
	}
	// Wasna klasa wyjtkw wywodzca si z ApplicationException
	class Custom1Exception : ApplicationException
	{
		public Custom1Exception(String msg) : base(msg)
		{
		}
	}
	class Custom2Exception : ApplicationException
	{
		public Custom2Exception(String msg) : base(msg)
		{
		}
	}
	class Custom3Exception : ApplicationException
	{
		public Custom3Exception(String msg) : base(msg)
		{
		}
	}
	class Custom4Exception : ApplicationException
	{
		public Custom4Exception(String msg) : base(msg)
		{
		}
	}
	class CustomException : ApplicationException
	{
		public CustomException(String msg) : base(msg)
		{
		}
	}

	class UnmanagedException
	{
		public UnmanagedException(int err)
		{
			this.err = err;
		}
		public int err;
	}

	/// <summary>
	/// Podsumowanie BasicExceptions.
	/// </summary>
	// By moe nienajlepsza procedura obsugi zdarzenia.
	class BasicExceptions
	{
		[DllImport("user32.dll")]
		public static extern int MessageBox(int hWnd, string text, string caption, uint type);

		static void SecretMethod()
		{
			// Utworzenie obiektu uprawnie zabezpiecze w celu opisania
			// uprawnienia UnmanagedCode:
			SecurityPermission perm = 
				new SecurityPermission(SecurityPermissionFlag.UnmanagedCode);

			// Odrzuca UnmanagedCode z aktualnego zestawu uprawnie.
			// adna metoda wywoywana w tym wtku nie uzyska dostpu 
			// do niezarzdzanego kodu a do momentu powrotu tej metody.

			perm.Deny();
			MessageBox(0, "Oto moja tajna metoda.", "cile tajne", 0);
		}
		static void Main(string[] args)
		{
			// Ustawienie procedury obsugi wyjtku
			Thread.GetDomain().UnhandledException += 
				new UnhandledExceptionEventHandler(UnhandledExceptionHandler);

			Console.WriteLine("\nDzielenie przez zero\n");

			// Prba dzielenia przez zero
			try
			{
				int x = 0;
				x = 1/x;
			}
			catch(DivideByZeroException e)
			{
				// Pobranie interesujcych informacji o wyjtku
				Console.WriteLine (e.ToString());
			}

			Console.WriteLine("\nNaruszenie dostpu\n");

			// Prba naruszenia dostpu
			try
			{
				Object o = null;
				Console.WriteLine(o.ToString());
			}
			catch(NullReferenceException e)
			{
				// Pobranie interesujcych informacji o wyjtku
				Console.WriteLine (e.ToString());
			}

			Console.WriteLine("\nPrzepenienie stosu\n");
			try
			{
				// Recurse.StackOverflow();
			}
			catch(StackOverflowException e)
			{
				// Pobranie interesujcych informacji o wyjtku
				Console.WriteLine (e.ToString());
			}

			Console.WriteLine("\nWasny wyjtek\n");

			// Prba zgoszenia wasnego wyjtku
			try
			{
				throw new CustomException("Zgaszam wasny wyjtek");
			}
			catch(CustomException e)
			{
				// Pobranie interesujcych informacji o wyjtku
				Console.WriteLine (e.ToString());
			}

			Console.WriteLine("\nWyjtek zwizany z obiektem\n");

			// Prba zgoszenia wyjtku zwizanego z obiektem (InvalidCast)
			try
			{
				int n = 5;
				Object o = n;
				string s = (string)o;
			}
			catch(InvalidCastException e)
			{
				// Pobranie interesujcych informacji o wyjtku
				Console.WriteLine (e.ToString());
			}

			Console.WriteLine("\nUprawnienie zabezpiecze\n");
			try
			{
				SecretMethod();
			}
			catch(SecurityException e)
			{
				// Pobranie interesujcych informacji o wyjtku
				Console.WriteLine (e.ToString());
			}

			Console.WriteLine("\nWyjtki wejcia-wyjcia pliku\n");
			StreamReader streamReader = null;
			try 
			{
				FileStream stream = File.OpenRead(@"..\..\BasicExceptions.cs");
				streamReader = new StreamReader(stream, Encoding.ASCII);
				streamReader.BaseStream.Seek(0, SeekOrigin.Begin);
				string s = streamReader.ReadToEnd();
				streamReader.BaseStream.Seek(0, SeekOrigin.Begin);
				// Console.WriteLine(s);
			}
			catch(Exception e)
			{
				// Pobranie interesujcych informacji o wyjtku
				Console.WriteLine ("Wystpi bd:\n{0}", e.ToString());
			}
			finally
			{
				Console.WriteLine ("Zamknicie pliku");
				if(streamReader != null)
					streamReader.Close();
			}


			Console.WriteLine("\nWyjtki filtrowania\n");
			try 
			{
				Random r = new Random();
				switch(r.Next(4) + 1)
				{
					case 1:
						throw new Custom1Exception("Zgaszam wyjtek Custom1Exception");
					case 2:
						throw new Custom2Exception("Zgaszam wyjtek Custom2Exception");
					case 3:
						throw new Custom3Exception("Zgaszam wyjtek Custom3Exception");
					case 4:
						throw new Custom4Exception("Zgaszam wyjtek Custom4Exception");
				}
			}
			catch(Custom1Exception e)
			{
				Console.WriteLine ("Wystpi bd Custom1Exception.\n{0}", e.ToString());
			}
			catch(Custom2Exception e)
			{
				Console.WriteLine ("Wystpi bd Custom2Exception.\n{0}", e.ToString());
			}
			catch(Custom3Exception e)
			{
				Console.WriteLine ("Wystpi bd Custom3Exception.\n{0}", e.ToString());
			}
			catch(Custom4Exception e)
			{
				Console.WriteLine ("Wystpi bd Custom4Exception.\n{0}", e.ToString());
			}

			// Przykad zego stylu programowania.
			int sum = 0;
			int i = 0;
			int [] array = new int [] {1,2,3,4,5,6};
			try
			{
				while(true)
				{
					sum += array[i++];
				}
			}
			catch(Exception e)
			{
				Console.WriteLine ("\nWyjtek granicy tablicy:\n{0}", e);
			}
			Console.WriteLine("\nSuma to {0}\n", sum);

			Console.WriteLine("\nDzielenie przez zero\n");

			Console.WriteLine("\nZagniedone wyjtki\n");
			try
			{
				// Prba dzielenia przez zero
				try
				{
					int x = 0;
					x = 1/x;
				}
				catch(DivideByZeroException e)
				{
					// Pobranie interesujcych informacji o wyjtku
					Console.WriteLine (e.ToString());
					throw;
				}
			}
			catch(DivideByZeroException e)
			{
				// Pobranie interesujcych informacji o wyjtku
				Console.WriteLine (e.ToString());
			}

			Console.WriteLine("\nNieobsugiwany wyjtek\n");

			// Prba dzielenia przez zero i sprawdzenie efektw.
			int y = 0;
			y = 1 / y;

			Console.WriteLine("\nTo miejsce nigdy nie zostanie osignite.\n");
		}
		public static void UnhandledExceptionHandler(object sender, UnhandledExceptionEventArgs args)
		{
			ConsoleWriteLine("Nieobsugiwany wyjtek!");
			ConsoleWriteLine("Nadawca: {0}", sender.ToString());
			ConsoleWriteLine("Typ: {0}", args.ExceptionObject.GetType().ToString());
			ConsoleWriteLine("Przerywany: {0}", args.IsTerminating);
		}
	}
}
